#include <iostream>
#include <algorithm>
#include <stack>

using namespace std;

struct Jarbol{
    long long x;
    long long h;
    long long i;
};

long long rastojanje(Jarbol *a, Jarbol *b) {
    return abs(a->x - b->x) - abs(a->h - b->h);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    long long n;
    cin >> n;
    
    Jarbol svi_jarboli[n];
    for(int i = 0; i < n; i++) {
        cin >> svi_jarboli[i].x;
        svi_jarboli[i].i = i;
    }
    for(int i = 0; i < n; i++)
        cin >> svi_jarboli[i].h;
    
    sort(svi_jarboli, svi_jarboli + n, [](const Jarbol &a, const Jarbol &b) {
        return a.x < b.x;
    });
    
    long long udaljenost[n];
    stack<Jarbol*> jarboli;
    jarboli.push(&svi_jarboli[0]);
    for(int i = 1; i < n; i++) {
        while(jarboli.top()->h < svi_jarboli[i].h) {
            Jarbol *jarbol = jarboli.top();
            jarboli.pop();
            
            if(jarboli.empty()) {
                udaljenost[jarbol->i] = rastojanje(jarbol, &svi_jarboli[i]);
                break;
            }
            
            udaljenost[jarbol->i] = min(rastojanje(jarboli.top(), jarbol), rastojanje(jarbol, &svi_jarboli[i]));
        }
        jarboli.push(&svi_jarboli[i]);
    }
    while(!jarboli.empty()) {
        Jarbol *jarbol = jarboli.top();
        jarboli.pop();
        
        if(!jarboli.empty())
            udaljenost[jarbol->i] = rastojanje(jarboli.top(), jarbol);
        else
            udaljenost[jarbol->i] = -1;
        
        if(jarboli.size() == 1 && jarbol->h == jarboli.top()->h) {
            udaljenost[jarboli.top()->i] = udaljenost[jarbol->i];
            jarboli.pop();
        }
    }
    
    for(int i = 0; i < n; i++)
        cout << udaljenost[i] << '\n';

        return 0;
}